<?php
if (isset($_POST['submit'])){
    //Add DB Connection
    require 'database.php';
    
    $firstname = $_POST['firstname'];
    $lastname = $_POST['lastname'];
    $pathway = $_POST['pathway'];
    $username = $_POST['username'];
    $confirmPass = $_POST['confirmPassword'];
    
    if (empty($firstname) ||empty($lastname) || empty($pathway) || empty($username) || empty($confirmPass)){
       header("Location: ../register.php?error=emptyfields&username=".$username); 
        exit();
    } elseif (!preg_match("/^[a-zA-Z0-9]*/", $username)) {
      header("Location: ../register.php?error=invalid username&username=".$username); 
        exit();  
    } elseif ($password !== $cofirmPassword){
        header("Location: ../register.php?error=passwordsdonotmatch&username=".$username); 
        exit();
    } else {
        $sql ="SELECT username FROM apprentice_info WHERE first_name=? AND last_name=?";
        $stmt =  mysqli_stmt_init($conn);
        if (!mysqli_stmt_prepare($stmt, $sql)) {
            header("Location: ../register.php?error=sqlerror");
            exit();
        } else {
            mysqli_stmt_bind_param($stmt, "ss",$firstname, $lastname);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_store_result($stmt);
            $row = mysqli_stmt_num_rows($stmt);
        }
            if ($rowCount> 0) {
                header("Location: ../register.php?error=usernametaken"); 
                exit();
            } else {
                $sql ="INSERT INTO apprentice_info (first_name, last_name, pathway, username, password) VALUES (?,?,?,?,?)";
                if (!mysqli_stmt_prepare($stmt, $sql)) {
                header("Location: ../register.php?error=sqlerror");
                exit();
                } else {
                  $hashedPass = password_hash($confirmPass, PASSWORD_DEFAULT);
                  mysqli_stmt_bind_param($stmt, "sssss", $firstname, $lastname,$pathway, $username,$hashedPass);
                  mysqli_stmt_execute($stmt);
                  header("Location: ../register.php?success=registered");
                  exit();
                }
            }
    }
    mysqli_stmt_close($stmt);
    mysqli_close($con);
    
}

?>